/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/15
*描  述:  XTAL例程
          选择系统使用外部8M晶振XTAL时钟
          注：此处测试需要焊接8M晶振，不要使用母板（母板连接线路会对晶振产生影响），只需要使用子板即可
              配置字XTAL需配置为HS
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"
#include "string.h"


void SetOscPort(void)
{
    GPIO_InitStruType x;
    memset(&x, 0, sizeof(x));

    x.GPIO_Signal = GPIO_Pin_Signal_Analog;  //OSC对应GPIO设置为模拟口
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_14, &x);    //OSC0I
    GPIO_Init(GPIOA, GPIO_Pin_15, &x);    //OSC0O

}

int main(void)
{
    SetOscPort();
    SystemClockSelect(CLK_SEL_XTAL);       //选择XTAL
    SystemCoreClock = 8000000;                              //其他规格晶振在此处修改即可
    DeviceClockAllEnable();

    SysTickInit();
    LightInit();

    while (1)
    {
        GPIOA_ResetBit(GPIO_Pin_12);
        Delay1ms(500);
        GPIOA_SetBit(GPIO_Pin_12);
        Delay1ms(500);
    }
}
