/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"

__IO uint8_t g_rxbuf;

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}
/*********************************************************
函数名: void UART0_IRQHandler(void)
描  述: UART中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UART0_IRQHandler(void)
{	
		if (UART_GetFlagStatus(UART0, UART_FLAG_RXIDLE) != RESET && UART_GetITStatus(UART0, UART_IT_RXIDLE) != RESET)
		{
			UART0->BRR.Word   = 0x209B;		/*波特率改为19200*/
			UART_ClearITPendingBit(UART0, UART_Clr_RXIDLE);
			UART_ITConfig(UART0, UART_IT_RXIDLE,DISABLE);
		}

    if (UART_GetFlagStatus(UART0, UART_FLAG_RB) != RESET && UART_GetITStatus(UART0, UART_IT_RB) != RESET)
    {				
        g_rxbuf = UART_RecByte(UART0);

        while (UART_GetFlagStatus(UART0, UART_FLAG_TB) == RESET);

        UART_SendByte(UART0, g_rxbuf);
			
    }
}

/*********************************************************
函数名: void PINT4_IRQHandler(void)
描  述: PINT中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void PINT4_IRQHandler(void)
{
		PINT_ClearITPendingBit(PINT_IT_PINT4);
	
		while (UART_GetFlagStatus(UART0, UART_FLAG_URIDIF) != RESET);
	
		UART0->BRR.Word     	= 0x4137;		/*波特率改为9600*/
}
