/*********************************************************

*文件名:    main.c
*作  者:    AE Team
*版  本:    V1.00
*日  期:    2021/11/11
*描  述:    UART演示主程序，TX:PA8，RX:PA7
            定义了串口通信主机请求/从机应答的通讯协议，上电后，MCU会向上位机发送一帧完整协议示例
            通讯协议如下：
            数据帧头1（固定）    0x55
            数据帧头2（固定）    0xAA
            设备地址（Addr）     0x01
            数据字节（N个）      DataN
            校验码（异或和）     = 0x55 ^ 0xAA ^ Addr ^ Func ^ Data1 ^ … ^ DataN
            数据帧尾1（固定）    0x5A
            数据帧尾2（固定）    0xA5
            按照协议，MCU接收上位机发送的数据帧，应答同样的数据，校验错误则丢弃该数据帧
            例如数据帧为字符串“EASTSOFT”
            上位机发送：55 AA 01 45 41 53 54 53 4F 46 54 F3 5A A5
            上位机接收：55 AA 01 45 41 53 54 53 4F 46 54 F3 5A A5
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t g_txbuf[0xFF];            //发送数据缓存
uint8_t g_tx_length;            //发送数据长度
uint8_t g_tx_count;             //发送字节计数

uint8_t g_rxbuf[0xFF];            //接收数据缓存
uint8_t g_rx_length;            //接收数据长度
uint8_t g_rx_count;             //接收字节计数
uint8_t g_rx_time;              //接收计时
uint8_t g_rx_finish_flag;       //接收完成标志
uint8_t g_rx_start_flag;        //接收起始标志

int main(void)
{
    uint32_t i;

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    UARTInit();                         //UART初始化(115200,8,NO,1)
    T16N3Init();

    g_tx_length = 0;                                    //发送数据长度
    g_tx_count = 0;                                     //发送字节计数
    g_rx_length = 0;                                    //接收数据长度
    g_rx_count = 0;                                     //接收字节计数
    g_rx_time = 0;                                      //接收计时
    g_rx_finish_flag = 0;                               //接收完成标志
    g_rx_start_flag = 0;                                //接收起始标志

    g_txbuf[3] = 'E';  //0x45
    g_txbuf[4] = 'A';  //0x41
    g_txbuf[5] = 'S';  //0x53
    g_txbuf[6] = 'T';  //0x54
    g_txbuf[7] = 'S';  //0x53
    g_txbuf[8] = 'O';  //0x4F
    g_txbuf[9] = 'F';  //0x46
    g_txbuf[10] = 'T'; //0x54

    g_tx_length = 14;
    UARTTxData(g_txbuf, g_tx_length);                   //发送数据帧“EASTSOFT”

    while (1)
    {
        if (1 == g_rx_finish_flag)
        {
            g_rx_finish_flag = 0;
            g_rx_length = g_rx_count;
            g_rx_count = 0;
            g_tx_length = g_rx_length;

            if (0 == UARTRxData(g_rxbuf, g_rx_length))  //接收数据帧
            {
                g_tx_length = g_rx_length;              //赋值发送长度，等同接收数据长度

                for (i = 3; i < g_tx_length - 3; i++)   //准备发送数据（功能码+数据内容）
                    g_txbuf[i] = g_rxbuf[i];            //等同于接收数据内容

                UARTTxData(g_txbuf, g_tx_length);       //发送数据帧
            }
        }
    }
}

