/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd
*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  T32N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void T32NxInit(void)
描  述: T32Nx定时器初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32NxInit(void)
{
    TIM_BaseInitStruType x;
    memset(&x, 0, sizeof(x));

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_TC0;
    T32Nx_BaseInit(T32N0, &x);

    T32Nx_SetPREMAT(T32N0, 1);

    T32Nx_SetMAT0(T32N0, 32000);

    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, ENABLE);

    T32Nx_MAT0ITConfig(T32N0, TIM_Clr_Int);

    T32Nx_ITConfig(T32N0, TIM_IT_MAT0, ENABLE);

    T32N0_Enable();
}
