/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

uint32_t count0 = 0;
uint32_t buf0[50] = {0};
uint32_t count1 = 0;
uint32_t buf1[50] = {0};

uint32_t count = 0;
/*********************************************************
函数名: void T32N0_IRQHandler(void)
描  述: T32N0定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32N0_IRQHandler(void)
{
    if (T32Nx_GetITStatus(T32N0, TIM_IT_CAP0) != RESET)
    {
        T32Nx_ClearIFPendingBit(T32N0, TIM_IF_CAP0);

        buf0[count0++]  = T32N0->MAT0.Word;
        buf0[count0++]  = T32N0->MAT2.Word;

        if (count0 >= 50)
            count0 = 0;

        count++;

        if ((count % 100) < 50)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }

    if (T32Nx_GetITStatus(T32N0, TIM_IT_CAP1) != RESET)
    {
        T32Nx_ClearIFPendingBit(T32N0, TIM_IF_CAP1);

        buf1[count1++]  = T32N0->MAT1.Word;
        buf1[count1++]  = T32N0->MAT3.Word;

        if (count1 >= 50)
            count1 = 0;

        count++;

        if ((count % 100) < 50)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }
}
