/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd
*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:  T32N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void T32N0CAPInit(void)
描  述: T32N0定时器初始化 输入端口0,1上升沿，捕获1次
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32N0CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));

    z.GPIO_Signal = GPIO_Pin_Signal_Digital;
    z.GPIO_Func = GPIO_Func_1;
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = GPIO_PUE_Input_Disable;
    z.GPIO_PDEN = GPIO_PDE_Input_Disable;
    z.GPIO_OD = GPIO_ODE_Output_Disable;
    z.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_21, &z);
    GPIO_Init(GPIOA, GPIO_Pin_22, &z);

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T32Nx_BaseInit(T32N0, &x);

    T32Nx_SetPREMAT(T32N0, 160);   //预分频

    T32Nx_MAT0ITConfig(T32N0, TIM_Go_No);               //MAT0匹配设置
    T32Nx_MAT2ITConfig(T32N0, TIM_Go_No);               //MAT2匹配设置
    T32Nx_MAT1ITConfig(T32N0, TIM_Go_No);               //MAT1匹配设置
    T32Nx_MAT3ITConfig(T32N0, TIM_Go_No);               //MAT3匹配设置

    y.TIM_CapCapl0 = ENABLE;
    y.TIM_CapCapl1 = ENABLE;
    y.TIM_CapRise = ENABLE;
    y.TIM_CapFall = DISABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_1;                      //捕捉1次
    T32Nx_CapInit(T32N0, &y);

    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, ENABLE); //中断设置
    T32N0_Enable();                                     //使能定时器
    T32Nx_ITConfig(T32N0, TIM_IT_CAP0, ENABLE);         //输入端口0捕捉中断
    T32Nx_ITConfig(T32N0, TIM_IT_CAP1, ENABLE);         //输入端口1捕捉中断

}
