/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd
*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  T32N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "timer.h"

/*********************************************************
函数名: void T16NxInit(void)
描  述: T16Nx定时器初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16NxInit(void)
{
    TIM_BaseInitStruType x;

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_TC0;
    T16Nx_BaseInit(T16N0, &x);
    T16Nx_BaseInit(T16N1, &x);
    T16Nx_BaseInit(T16N2, &x);
    T16Nx_BaseInit(T16N3, &x);

    T16Nx_SetPREMAT(T16N0, 1);
    T16Nx_SetPREMAT(T16N1, 1);
    T16Nx_SetPREMAT(T16N2, 1);
    T16Nx_SetPREMAT(T16N3, 1);

    T16Nx_SetMAT0(T16N0, 32000);
    T16Nx_SetMAT0(T16N1, 32000);
    T16Nx_SetMAT0(T16N2, 32000);
    T16Nx_SetMAT0(T16N3, 32000);

    NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, ENABLE);
    NVIC_Init(NVIC_T16N1_IRQn, NVIC_Priority_1, ENABLE);
    NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, ENABLE);
    NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, ENABLE);

    T16Nx_MAT0ITConfig(T16N0, TIM_Clr_Int);
    T16Nx_MAT0ITConfig(T16N1, TIM_Clr_Int);
    T16Nx_MAT0ITConfig(T16N2, TIM_Clr_Int);
    T16Nx_MAT0ITConfig(T16N3, TIM_Clr_Int);

    T16Nx_ITConfig(T16N0, TIM_IT_MAT0, ENABLE);
    T16Nx_ITConfig(T16N1, TIM_IT_MAT0, ENABLE);
    T16Nx_ITConfig(T16N2, TIM_IT_MAT0, ENABLE);
    T16Nx_ITConfig(T16N3, TIM_IT_MAT0, ENABLE);

    T16N0_Enable();
    T16N1_Enable();
    T16N2_Enable();
    T16N3_Enable();
}
