/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  TN16N0-TN16N3分别定时，间隔不同时间，闪烁对应LD1-LD4指示灯
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "main.h"

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();                      //初始化系统滴答定时器
    LightInit();                        //指示灯初始化
    T16NxInit();

    GPIOB_SetBit(GPIO_Pin_14);          //熄灭LD4
    GPIOB_SetBit(GPIO_Pin_15);          //熄灭LD3
    GPIOA_SetBit(GPIO_Pin_11);          //熄灭LD2
    GPIOA_SetBit(GPIO_Pin_12);          //熄灭LD1

    while (1);
}
