/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:  PA21引脚输入下降沿方波信号
          T16N3计数一次发生中断触发，LD1指示灯翻转
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "main.h"

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    LightInit();
    T16N3CNT_Init();                    //PA21输入计数，使用时开发板不要上电

    GPIOB_SetBit(GPIO_Pin_14);          //熄灭LD4
    GPIOB_SetBit(GPIO_Pin_15);          //熄灭LD3
    GPIOA_SetBit(GPIO_Pin_11);          //熄灭LD2
    GPIOA_SetBit(GPIO_Pin_12);          //熄灭LD1

    while (1);
}
