/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

uint32_t count00 = 0;
uint32_t buf00[50] = {0};
uint32_t count01 = 0;
uint32_t buf01[50] = {0};

uint32_t count10 = 0;
uint32_t buf10[50] = {0};
uint32_t count11 = 0;
uint32_t buf11[50] = {0};

uint32_t count20 = 0;
uint32_t buf20[50] = {0};
uint32_t count21 = 0;
uint32_t buf21[50] = {0};

uint32_t count30 = 0;
uint32_t buf30[50] = {0};
uint32_t count31 = 0;
uint32_t buf31[50] = {0};

uint32_t count = 0;

/*********************************************************
函数名: void T16N0_IRQHandler(void)
描  述: T16N2定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N0_IRQHandler(void)
{
    if (T16Nx_GetFlagStatus(T16N0, TIM_IF_CAP0) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N0, TIM_IF_CAP0);

        buf00[count00++]  = T16N0->MAT0.Word;
        buf00[count00++]  = T16N0->MAT2.Word;

        if (count00 >= 50)
            count00 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }

    if (T16Nx_GetFlagStatus(T16N0, TIM_IF_CAP1) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N0, TIM_IF_CAP1);

        buf01[count01++]  = T16N0->MAT1.Word;
        buf01[count01++]  = T16N0->MAT3.Word;

        if (count01 >= 50)
            count01 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }
}
/*********************************************************
函数名: void T16N1_IRQHandler(void)
描  述: T16N1定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N1_IRQHandler(void)
{
    if (T16Nx_GetFlagStatus(T16N1, TIM_IF_CAP0) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N1, TIM_IF_CAP0);

        buf10[count10++]  = T16N1->MAT0.Word;
        buf10[count10++]  = T16N1->MAT2.Word;

        if (count10 >= 50)
            count10 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }

    if (T16Nx_GetFlagStatus(T16N1, TIM_IF_CAP1) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N1, TIM_IF_CAP1);

        buf11[count11++]  = T16N1->MAT1.Word;
        buf11[count11++]  = T16N1->MAT3.Word;

        if (count11 >= 50)
            count11 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }
}
/*********************************************************
函数名: void T16N2_IRQHandler(void)
描  述: T16N2定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N2_IRQHandler(void)
{
    if (T16Nx_GetFlagStatus(T16N2, TIM_IF_CAP0) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N2, TIM_IF_CAP0);

        buf20[count20++]  = T16N2->MAT0.Word;
        buf20[count20++]  = T16N2->MAT2.Word;

        if (count20 >= 50)
            count20 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }

    if (T16Nx_GetFlagStatus(T16N2, TIM_IF_CAP1) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N2, TIM_IF_CAP1);

        buf21[count21++]  = T16N2->MAT1.Word;
        buf21[count21++]  = T16N2->MAT3.Word;

        if (count21 >= 50)
            count21 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }
}
/*********************************************************
函数名: void T16N3_IRQHandler(void)
描  述: T16N3定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N3_IRQHandler(void)
{
    if (T16Nx_GetFlagStatus(T16N3, TIM_IF_CAP0) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N3, TIM_IF_CAP0);

        buf30[count30++]  = T16N3->MAT0.Word;
        buf30[count30++]  = T16N3->MAT2.Word;

        if (count30 >= 50)
            count30 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }

    if (T16Nx_GetFlagStatus(T16N3, TIM_IF_CAP1) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N3, TIM_IF_CAP1);

        buf31[count31++]  = T16N3->MAT1.Word;
        buf31[count31++]  = T16N3->MAT3.Word;

        if (count31 >= 50)
            count31 = 0;

        count++;

        if ((count & 0x01) == 0x01)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
        }
    }
}

