/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd
*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:  T16N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void T16N0CAPInit(void)
描  述: T16N0定时器初始化 输入端口0,1上升沿，捕获10次
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N0CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));

    z.GPIO_Signal = GPIO_Pin_Signal_Digital;
    z.GPIO_Func = GPIO_Func_1;
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = GPIO_PUE_Input_Disable;
    z.GPIO_PDEN = GPIO_PDE_Input_Disable;
    z.GPIO_OD = GPIO_ODE_Output_Disable;
    z.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOB, GPIO_Pin_4, &z);
    GPIO_Init(GPIOB, GPIO_Pin_5, &z);

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T16Nx_BaseInit(T16N0, &x);

    T16Nx_SetPREMAT(T16N0, 160);   //预分频

    T16Nx_MAT0ITConfig(T16N0, TIM_Go_No);               //MAT0匹配设置
    T16Nx_MAT2ITConfig(T16N0, TIM_Go_No);               //MAT2匹配设置
    T16Nx_MAT1ITConfig(T16N0, TIM_Go_No);               //MAT1匹配设置
    T16Nx_MAT3ITConfig(T16N0, TIM_Go_No);               //MAT3匹配设置

    y.TIM_CapCapl1 = ENABLE;
    y.TIM_CapCapl0 = ENABLE;
    y.TIM_CapFall = DISABLE;
    y.TIM_CapRise = ENABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_10;                      //捕捉10次
    T16Nx_CapInit(T16N0, &y);

    NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, ENABLE); //中断设置
    T16N0_Enable();                                     //使能定时器
    T16Nx_ITConfig(T16N0, TIM_IT_CAP0, ENABLE);         //输入端口0捕捉中断
    T16Nx_ITConfig(T16N0, TIM_IT_CAP1, ENABLE);         //输入端口1捕捉中断

}
/*********************************************************
函数名: void T16N1CAPInit(void)
描  述: T16N1定时器初始化 输入端口0,1，下降沿，捕获8次
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N1CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));

    z.GPIO_Signal = GPIO_Pin_Signal_Digital;
    z.GPIO_Func = GPIO_Func_1;
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = GPIO_PUE_Input_Disable;
    z.GPIO_PDEN = GPIO_PDE_Input_Disable;
    z.GPIO_OD = GPIO_ODE_Output_Disable;
    z.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOB, GPIO_Pin_6, &z);
    GPIO_Init(GPIOB, GPIO_Pin_7, &z);

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T16Nx_BaseInit(T16N1, &x);

    T16Nx_SetPREMAT(T16N1, 160);   //预分频

    T16Nx_MAT0ITConfig(T16N1, TIM_Go_No);               //MAT0匹配设置
    T16Nx_MAT2ITConfig(T16N1, TIM_Go_No);               //MAT2匹配设置
    T16Nx_MAT1ITConfig(T16N1, TIM_Go_No);               //MAT1匹配设置
    T16Nx_MAT3ITConfig(T16N1, TIM_Go_No);               //MAT3匹配设置

    y.TIM_CapCapl1 = ENABLE;
    y.TIM_CapCapl0 = ENABLE;
    y.TIM_CapRise = DISABLE;
    y.TIM_CapFall = ENABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_8;                      //捕捉8次
    T16Nx_CapInit(T16N1, &y);

    NVIC_Init(NVIC_T16N1_IRQn, NVIC_Priority_1, ENABLE); //中断设置
    T16N1_Enable();                                     //使能定时器
    T16Nx_ITConfig(T16N1, TIM_IT_CAP0, ENABLE);         //输入端口0捕捉中断
    T16Nx_ITConfig(T16N1, TIM_IT_CAP1, ENABLE);         //输入端口1捕捉中断

}

/*********************************************************
函数名: void T16N2CAPInit(void)
描  述: T16N2定时器初始化 输入端口0,1上升沿，捕获4次
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N2CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));

    z.GPIO_Signal = GPIO_Pin_Signal_Digital;
    z.GPIO_Func = GPIO_Func_3;
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = GPIO_PUE_Input_Disable;
    z.GPIO_PDEN = GPIO_PDE_Input_Disable;
    z.GPIO_OD = GPIO_ODE_Output_Disable;
    z.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_28, &z);
    GPIO_Init(GPIOA, GPIO_Pin_29, &z);

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T16Nx_BaseInit(T16N2, &x);

    T16Nx_SetPREMAT(T16N2, 160);   //预分频

    T16Nx_MAT0ITConfig(T16N2, TIM_Go_No);               //MAT0匹配设置
    T16Nx_MAT2ITConfig(T16N2, TIM_Go_No);               //MAT2匹配设置
    T16Nx_MAT1ITConfig(T16N2, TIM_Go_No);               //MAT1匹配设置
    T16Nx_MAT3ITConfig(T16N2, TIM_Go_No);               //MAT3匹配设置

    y.TIM_CapCapl1 = ENABLE;
    y.TIM_CapCapl0 = ENABLE;
    y.TIM_CapRise = ENABLE;
    y.TIM_CapFall = DISABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_4;                      //捕捉4次
    T16Nx_CapInit(T16N2, &y);

    NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, ENABLE); //中断设置
    T16N2_Enable();                                     //使能定时器
    T16Nx_ITConfig(T16N2, TIM_IT_CAP0, ENABLE);         //输入端口0捕捉中断
    T16Nx_ITConfig(T16N2, TIM_IT_CAP1, ENABLE);         //输入端口1捕捉中断

}

/*********************************************************
函数名: void T16N3CAPInit(void)
描  述: T16N3定时器初始化 输入端口0,1，上升+下降沿，捕获2次
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N3CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));

    z.GPIO_Signal = GPIO_Pin_Signal_Digital;
    z.GPIO_Func = GPIO_Func_3;
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = GPIO_PUE_Input_Disable;
    z.GPIO_PDEN = GPIO_PDE_Input_Disable;
    z.GPIO_OD = GPIO_ODE_Output_Disable;
    z.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOB, GPIO_Pin_2, &z);
    GPIO_Init(GPIOB, GPIO_Pin_3, &z);

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T16Nx_BaseInit(T16N3, &x);

    T16Nx_SetPREMAT(T16N3, 160);   //预分频

    T16Nx_MAT0ITConfig(T16N3, TIM_Go_No);               //MAT0匹配设置
    T16Nx_MAT2ITConfig(T16N3, TIM_Go_No);               //MAT2匹配设置
    T16Nx_MAT1ITConfig(T16N3, TIM_Go_No);               //MAT1匹配设置
    T16Nx_MAT3ITConfig(T16N3, TIM_Go_No);               //MAT3匹配设置

    y.TIM_CapCapl1 = ENABLE;
    y.TIM_CapCapl0 = ENABLE;
    y.TIM_CapRise = ENABLE;
    y.TIM_CapFall = ENABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_2;                      //捕捉2次
    T16Nx_CapInit(T16N3, &y);

    NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, ENABLE); //中断设置
    T16N3_Enable();                                     //使能定时器
    T16Nx_ITConfig(T16N3, TIM_IT_CAP0, ENABLE);         //输入端口0捕捉中断
    T16Nx_ITConfig(T16N3, TIM_IT_CAP1, ENABLE);         //输入端口1捕捉中断

}
