/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"
extern uint8_t g_wbuf[8];
extern uint8_t g_rbuf[8];
uint32_t recv_cnt;
uint32_t send_cnt;

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}
void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

void SPI0_IRQHandler(void)
{
    if ((SPI_GetFlagStatus(SPI_Flag_RB) == SET) && (SPI_GetITStatus(SPI_IT_RB) == SET))
    {
        g_rbuf[recv_cnt++] = SPI_RecByte();
        memcpy(g_wbuf, g_rbuf, recv_cnt);

        if (recv_cnt > 7)
        {
            recv_cnt = 0;
        }
    }

    if ((SPI_GetFlagStatus(SPI_Flag_TB) == SET) && (SPI_GetITStatus(SPI_IT_TB) == SET))
    {
        SPI_SendByte(g_wbuf[send_cnt++]);

        if (send_cnt > 7)
        {
            send_cnt = 0;
        }
    }
}
