/*********************************************************

*文件名:  spi.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  SPI主机模块
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "spi.h"
#include "string.h"
/*********************************************************
函数名: void SPI_GPIO_Init(void)
描  述: SPI_GPIO初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void SPI_GPIO_Init(void)
{
    GPIO_InitStruType x;
    SPI_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, SCK_PIN, &x);      //PA26-SCK,PA27-NSS,PA24-SDO-MOSI    FUN3
    GPIO_Init(GPIOA, SDO_PIN, &x);
    GPIO_Init(GPIOA, CS_PIN, &x);       //GPIO端口初始化

    x.GPIO_Direction = GPIO_Dir_Out;
    GPIO_Init(GPIOA, SDI_PIN, &x);

    y.SPI_Freq = 80000;
    y.SPI_Df = SPI_RiseSendFallRec;
    y.SPI_Mode = SPI_Mode_Slave;
    y.SPI_DW = 7;
    y.SPI_DelayRec = ENABLE;            //接收延时使能
    y.SPI_DelaySend = DISABLE;
    y.SPI_SendDelayPeroid = 0;
    SPI_Init(&y);                       //SPI初始化

    SPI_RBIMConfig(SPI_IType_BYTE);       /* RB满中断 */
    SPI_TBIMConfig(SPI_IType_BYTE);       /* TB空中断 */
    SPI_ITConfig(SPI_IT_TB, ENABLE);      /* 打开发送缓冲器中断 */
    SPI_ITConfig(SPI_IT_RB, ENABLE);      /* 打开接收缓冲器中断 */
    NVIC_Init(NVIC_SPI0_IRQn, NVIC_Priority_0, ENABLE);

    SPI_RecEnable();
    SPI_Enable();
}
