/*********************************************************

*文件名:  main.c
*作  者:  AT Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  SPI主从机通信程序，本程序为从机程序，主机使用ES-Bridge（通信频率勿超过328kHz），
          空闲时钟信号低电平，第二边沿采样；
          引脚连接：PA27-NSS，PA26-SCK，PA25-MISO，PA24-MOSI
          MCU接收主机发送的8字节数据，并保存起来，下次主机读的时候，发送保存的数据。
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <string.h>
#include "main.h"
#include "systick.h"

uint8_t g_wbuf[8];
uint8_t g_rbuf[8];

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);   //HRC选择16MHz
    SystemClockConfig();            //配置时钟
    DeviceClockAllEnable();         //打开所有外设时钟
    SysTickInit();

    SPI_GPIO_Init();

    while (1)
    {
    }
}
