/*********************************************************

*文件名:  spi.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  SPI主机模块头文件
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#ifndef __SPI_H__
#define __SPI_H__

#include <string.h>
#include "ES8H018x.h"
#include "lib_config.h"

#define CS_SET GPIOA_SetBit(GPIO_Pin_27)
#define CS_RESET GPIOA_ResetBit(GPIO_Pin_27)
#define SCK_PIN GPIO_Pin_26
#define CS_PIN  GPIO_Pin_27
#define SDI_PIN GPIO_Pin_25
#define SDO_PIN GPIO_Pin_24

extern volatile uint8_t rbufIndex;
extern volatile uint8_t wbufIndex;

/* 函数声明 */
void SPI_GPIO_Init(void);
void SPIReadData(uint8_t *rbuf, uint8_t n);
void SPIWriteData(uint8_t *wbuf, uint8_t n);

#endif
