/*********************************************************

*文件名:  spi.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  SPI主机模块
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "spi.h"
#include "string.h"
#define ISR 1

uint8_t g_wbuf[20];
uint8_t g_rbuf[20];
uint8_t g_rbufamount;
uint8_t g_wbufamount;

/*********************************************************
函数名: void SPI_GPIO_Init(void)
描  述: SPI_GPIO初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void SPI_GPIO_Init(void)
{
    GPIO_InitStruType x;
    SPI_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, SCK_PIN, &x);      //PA26-SCK,PA27-NSS,PA24-SDO-MOSI   FUN3
    GPIO_Init(GPIOA, SDO_PIN, &x);

    x.GPIO_Func = GPIO_Func_0;
    GPIO_Init(GPIOA, CS_PIN, &x);       //GPIO端口初始化

    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_In;
    GPIO_Init(GPIOA, SDI_PIN, &x);

    y.SPI_Freq = 10000;
    y.SPI_Df = SPI_RiseSendFallRec;
    y.SPI_Mode = SPI_Mode_Master;
    y.SPI_DW = 7;
    y.SPI_DelayRec = ENABLE;            //接收延时使能
    y.SPI_DelaySend = DISABLE;
    y.SPI_SendDelayPeroid = 0x3F;
    SPI_Init(&y);                       //SPI初始化

    CS_SET;
    SPI_RecEnable();
    SPI_RBIMConfig(SPI_IType_BYTE);
    SPI_TBIMConfig(SPI_IType_BYTE);
    NVIC_Init(NVIC_SPI0_IRQn, NVIC_Priority_0, ENABLE);
    SPI_Enable();
}

/*********************************************************
函数名: SPIReadData(uint8_t *rbuf, uint8_t n)
描  述: SPI读数据，连续字节读出(查询模式)
输入值: n—接收数据个数
输出值: rbuf—接收数据缓存
返回值: 无
**********************************************************/
void SPIReadData(uint8_t *rbuf, uint8_t n)
{
    uint8_t i;

    /* 清空接收缓冲器 */
    rbufIndex = 0x0U;
    g_rbufamount = n;
    SPI_TX_CLR();
    SPI_RX_CLR();

#if ISR
    SPI_ITConfig(SPI_IT_TB, DISABLE);
    SPI_ITConfig(SPI_IT_RB, ENABLE);
#endif

    /* 拉低片选 */
    CS_RESET;

    for (i = 0; i < n; i++)
    {
        while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

        SPI_SendByte(0x3F);

#if ISR
#else

        while ((SPI_GetFlagStatus(SPI_Flag_RB) == RESET));

        g_rbuf[i] = SPI_RecByte();
#endif
    }

#if ISR

    while (rbufIndex < n)
    {
        ;
    }

#endif

    CS_SET;

    memcpy(rbuf, g_rbuf, n);

    return;
}

/*********************************************************
函数名: SPIWriteData(uint8_t *wbuf, uint8_t n)
描  述: SPI写数据，连续字节读出(查询模式)
输入值: wbuf：发送的数据
        n—接收数据个数
输出值: 无
返回值: 无
**********************************************************/
void SPIWriteData(uint8_t *wbuf, uint8_t n)
{
#if ISR
#else
    uint8_t i;
#endif

    /* 清空发送缓冲器 */
    wbufIndex = 0x0U;
    g_wbufamount = n;
    memcpy(g_wbuf, wbuf, n);
    SPI_TX_CLR();

    /* 拉低片选 */
    CS_RESET;

#if ISR
    SPI_ITConfig(SPI_IT_TB, ENABLE);
    SPI_ITConfig(SPI_IT_RB, DISABLE);
#endif

#if ISR
#else

    for (i = 0; i < n; i++)
    {
        SPI_SendByte(wbuf[i]);

        while ((SPI_GetFlagStatus(SPI_Flag_TB) == RESET) || SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);
    }

#endif

#if ISR

    while (wbufIndex < n)
    {
        ;
    }

#endif

    /* 等待发送空闲 */
    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    CS_SET;

    return;
}
