/*********************************************************

*文件名:  uart.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:  UART模块头文件
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#ifndef __UART_H__
#define __UART_H__

#include "lib_config.h"

#define HEAD1       0x55        //帧头码1
#define HEAD2       0xAA        //帧头码2
#define TAIL1       0x5A        //帧尾码1
#define TAIL2       0xA5        //帧尾码2
#define SLAVE_ADDR      0x01        //设备地址
extern uint8_t flag;
void UARTInit(void);                //UART初始化
uint8_t UARTRxData(uint8_t *buf, uint8_t n);    //UART接收数据
void UARTTxData(uint8_t *buf, uint8_t n);       //UART发送数据

#endif
