/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  深度睡眠功耗分析示例程序
*         需使用ESBurner修改配置字，禁止Debug，功耗低至2uA左右
*         进入休眠前，LED亮一秒
*         外部端口中断唤醒，端口PA0接1
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟
    SysTickInit();                      //系统滴答初始化

    LightInit();
    LightOff();

    PINTx_Init();

    while (1)
    {
        LightOn();
        Delay1ms(1000);
        LightOff();
        /* 系统进入深睡 */
        deep_sleep();
    }
}
