/*********************************************************

*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  T32N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void PWM_Init(void)
描  述: pwm初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32Nx_Init(void)
{
    TIM_BaseInitStruType x;
    GPIO_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));

    x.TIM_ClkS = TIM_ClkS_PCLK;                         //选择时钟：Pclk
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_PWM ;                         //设为PWM模式
    T32Nx_BaseInit(T32N0, &x);

    T32N0_PwmOut0_Enable();                             //使能端口输出0
    T32Nx_MAT0Out0Config(T32N0, TIM_Out_High);          //匹配0：输出高
    T32Nx_MAT1Out0Config(T32N0, TIM_Out_Low);           //匹配1：输出低

    T32Nx_SetPREMAT(T32N0, 16);                         //预分频
    T32Nx_SetCNT(T32N0, 0);
    T32Nx_SetMAT0(T32N0, 500);                           //控制占空比
    T32Nx_SetMAT1(T32N0, 2000);                          //控制周期2ms

    T32Nx_MAT0ITConfig(T32N0, TIM_Go_Int);              //匹配0：继续计数
    T32Nx_MAT1ITConfig(T32N0, TIM_Clr_Int);             //匹配1：清0

    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, DISABLE);
    T32Nx_ITConfig(T32N0, TIM_IT_MAT0, DISABLE);        //可选择是否使能中断
    T32Nx_ITConfig(T32N0, TIM_IT_MAT1, DISABLE);

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_2;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_2, &y);                   //PA2

    T32N0_Enable();
}



