/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  定时器PWM输出演示主程序
          PA28引脚输出PWM波形，使用PWM调制模式触发ADC，ADC结果通过UART打印显示
          连线：
          PA8 - TXD
          PB6  - AD
          使用printf需以下步骤：
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint16_t g_adc_data;
uint8_t g_adc_flag;

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);   //HRC选择16MHz
    SystemClockConfig();            //配置时钟
    DeviceClockAllEnable();         //打开所有外设时钟

    UARTInit();
    T16Nx_Init();
    ADC0_UserInit();

    while (1)
    {
        if (1 == g_adc_flag)                             //中断读取采样ADC数值
        {
            g_adc_flag = 0;
            printf("PWM triggers ADC, AIN1: %d mV\r\n", g_adc_data);     //打印ADC值
        }
    }
}
