/*********************************************************
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  PLL例程
          HRC通过PLL倍频到48M后，定时闪烁LD1-LD4指示灯，先调用PLLClock_Config()函数，
                    可观测到系统时钟倍频至48MHz情况下LED灯的闪烁情况，屏蔽PLLClock_Config()函数，
          编译再下载后，系统时钟会更改为内部16MHz高速时钟，切记！！！此时应该应该硬件复位一下，
                    如不硬件复位，系统时钟还会以48MHz倍频时钟去工作。
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t g_2ms_flag;
uint8_t g_10ms_flag;
uint8_t g_10ms_cnt;
uint32_t g_500ms_flag;
uint32_t g_500ms_cnt;

int main(void)
{
    uint8_t clock_cnt = 0;

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz，PLL时钟源为HRC时，必须选16MHz
    SystemClockConfig();                //配置系统时钟HRC
    PLLClock_Config(ENABLE, SCU_PLL_HRC, SCU_PLL_48M, ENABLE);   //PLL使能，倍频到48M（可关闭打开分别观察指示灯闪烁差异）
    SystemCoreClock = 48000000;
    DeviceClockAllEnable();

    LightInit();
    T16N3Init();

    GPIOA_ResetBit(GPIO_Pin_12);
    GPIOA_ResetBit(GPIO_Pin_11);
    GPIOB_ResetBit(GPIO_Pin_15);
    GPIOB_ResetBit(GPIO_Pin_14);

    while (1)
    {
        if (1 == g_500ms_flag)
        {
            g_500ms_flag = 0;
            clock_cnt++;
        }

        if (clock_cnt % 2 == 1)
        {
            GPIOA_ResetBit(GPIO_Pin_12);
            GPIOA_ResetBit(GPIO_Pin_11);
            GPIOB_ResetBit(GPIO_Pin_15);
            GPIOB_ResetBit(GPIO_Pin_14);
        }
        else
        {
            GPIOA_SetBit(GPIO_Pin_12);
            GPIOA_SetBit(GPIO_Pin_11);
            GPIOB_SetBit(GPIO_Pin_15);
            GPIOB_SetBit(GPIO_Pin_14);
        }
    }
}
