/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/11
*描  述:  LVD程序：拨码开关由5V切换到3.3V时，LVD检测低于4.0V电压，再切换回5V后，则点亮LED1-LED4
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟

    SysTickInit();                      //系统滴答初始化
    LightInit();

    GPIOA_SetBit(GPIO_Pin_12);          //熄灭LD1
    GPIOA_SetBit(GPIO_Pin_11);          //熄灭LD2
    GPIOB_SetBit(GPIO_Pin_15);          //熄灭LD3
    GPIOB_SetBit(GPIO_Pin_14);          //熄灭LD4

    SCU_RegUnLock();

    NVIC_Init(NVIC_CCM_LVD_PLK_IRQn, NVIC_Priority_0, ENABLE);  //中断设置
    SCU_LVDVS_4V0();
    SCU_LVDIFS_Fall();
    SCU_LVDFLT_Enable();
    SCU_LVD_Enable();
    Delay100us(5);
    SCU_LVDIT_Enable();

    SCU_RegLock();

    while (1);
}
