/*********************************************************
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2023/08/15
*描  述:  LCD实时显示数字，初始状态“0000”，每隔1秒加1，显示“9999”后重新回到“0000”；
          显示10的倍数（除了“0000”）时，LCD闪烁。
*备  注:  需配合HRSDK-GMB-01板使用
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    uint32_t lcd_buf[8] = {0U};
    uint16_t i = 0U;
    uint8_t j = 0U;

    SystemHRCSelect(SCU_HRC_48M);       //HRC选择48MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟

    LCDInit();

    SysTickInit();

    while (1)
    {
        if (i != 0 && (i % 10) == 0)
            LCD_FlickerConfig(LCD_BLINK_1, 127);
        else
            LCD_FlickerConfig(LCD_BLINK_OFF, 0);

        lcd_display(lcd_buf, 1, i / 1000);
        lcd_display(lcd_buf, 2, i % 1000 / 100);
        lcd_display(lcd_buf, 3, i % 100 / 10);
        lcd_display(lcd_buf, 4, i % 10);
        lcd_reflush(lcd_buf);

        for (j = 0; j < 8; ++j)
            lcd_buf[j] = 0;

        Delay1ms(1000);

        i++;

        if (i >= 10000)
            i = 0;
    }
}
