/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"

uint8_t rxcnt;
uint8_t txcnt;

extern uint8_t g_buf[255];

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/***************************************************************
 函数名: void T16N3_IRQHandler(void)
 描  述：T16N3定时中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void T16N3_IRQHandler(void)
{

}
/***************************************************************
 函数名: void I2C0_IRQHandler(void)
 描  述：IIC中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void I2C0_IRQHandler(void)
{
    /* 收到起始位+地址匹配+发送应答位 */
    if ((I2C_GetITStatus(I2C_IT_SR) == SET) && (I2C_GetFlagStatus(I2C_Flag_SR) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_SR);

        if (I2C_GetRWMode() == I2C_Mode_Read)
        {
            txcnt = 0x0U;

            I2C_ClearITPendingBit(I2C_Clr_NA);
            I2C_ClearITPendingBit(I2C_Clr_TIDLE);
            I2C_ITConfig(I2C_IT_RB, DISABLE);
            I2C_ITConfig(I2C_IT_TIDLE, ENABLE);
            I2C_SendByte(g_buf[txcnt++]);
        }
        else if (I2C_GetRWMode() == I2C_Mode_Write)
        {
            rxcnt = 0x0U;

            I2C_ClearITPendingBit(I2C_Clr_NA);
            //I2C_ClearITPendingBit(I2C_Clr_TIDLE);
            I2C_ITConfig(I2C_IT_RB, ENABLE);
            I2C_ITConfig(I2C_IT_TIDLE, DISABLE);
        }
    }

    /* 接收中断 */
    if ((I2C_GetITStatus(I2C_IT_RB) == SET) && (I2C_GetFlagStatus(I2C_Flag_RB) == SET))
    {
        g_buf[rxcnt++] = I2C_RecByte();
    }

    /* 发送中断 */
    if ((I2C_GetITStatus(I2C_IT_TIDLE) == SET) && (I2C_GetFlagStatus(I2C_Flag_TIDLE) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_TIDLE);

        if (I2C_GetFlagStatus(I2C_Flag_NA) != SET)
        {
            I2C_SendByte(g_buf[txcnt++]);
        }
    }

    /* 收到结束位 */
    if ((I2C_GetITStatus(I2C_IT_SP) == SET) && (I2C_GetFlagStatus(I2C_Flag_SP) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_SP);
        I2C_ClearITPendingBit(I2C_Clr_NA);

        I2C_ITConfig(I2C_IT_RB, DISABLE);
        I2C_ITConfig(I2C_IT_TIDLE, DISABLE);
    }
}
