/*********************************************************

*文件名:  iic.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  IIC主机模块程序
          访问EEPROM
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "iic.h"
#include "systick.h"
#include "string.h"
/*********************************************************
函数名: void I2C0_SlaveInit(void)
描  述: IIC从机初始化子程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void I2C0_SlaveInit(void)
{
    GPIO_InitStruType x;
    I2C_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    //IIC0 PA30,31
    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PUEN = GPIO_PUE_Input_Enable;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Enable;
    x.GPIO_DS = GPIO_DS_Output_Strong;
    GPIO_Init(GPIOA, GPIO_Pin_31, &x);   //PA31--SCL
    GPIO_Init(GPIOA, GPIO_Pin_30, &x);   //PA30--SDA

    y.I2C_16XSamp = DISABLE;
    y.I2C_Mode = I2C_Mode_Slave;
    y.I2C_SclOd = I2C_PinMode_OD;
    y.I2C_SdaOd = I2C_PinMode_OD;
    y.I2C_AutoStop = DISABLE;
    y.I2C_AutoCall = DISABLE;
    y.I2C_Clk = 100000;        //100kHz

    I2C_Init(&y);
    I2C_TBIMConfig(I2C_TRBIM_Word);
    I2C_RBIMConfig(I2C_TRBIM_Byte);

    I2C_CSEnable();           //高速传输时必须将时钟自动下拉使能

    I2C_SetAddress(SLAVE_ADDR);
    I2C_ITConfig(I2C_IT_SR, ENABLE);
    I2C_ITConfig(I2C_IT_SP, ENABLE);
    NVIC_Init(NVIC_I2C0_IRQn, NVIC_Priority_0, ENABLE);

    I2C_Enable();
}
