/*********************************************************

*文件名:  iic.h
*作  者:  Ae Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  IIC主机模块头文件
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#ifndef __IICUSER_H__
#define __IICUSER_H__

#include "lib_config.h"
#include "string.h"

#define SLAVE_ADDR  0x2D << 1    //从机地址

void IICMasterInit(void);
uint8_t IICReadByte(uint8_t slave_addr);
ErrorStatus IICWriteByte(uint8_t slave_addr, uint8_t buf);
void IICReadBuf(uint8_t slave_addr, uint8_t *buf, uint8_t size);
ErrorStatus IICWriteBuf(uint8_t slave_addr, uint8_t *buf, uint8_t size);

#endif
