/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

/***************************************************************
 函数名: void T16N3_IRQHandler(void)
 描  述：T16N3定时中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void T16N3_IRQHandler(void)
{

}
/***************************************************************
 函数名: void I2C0_IRQHandler(void)
 描  述：IIC中断函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void I2C0_IRQHandler(void)
{
    if ((I2C_GetFlagStatus(I2C_Flag_SR) == SET) && (I2C_GetITStatus(I2C_IT_SR) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_SR);

        if (I2C_GetRWMode() == I2C_Mode_Read)   /* 判断I2C工作读写状态读取 */
        {
            I2C_RecModeConfig(I2C_RecMode_6);   /* 接收模式：连续接收，每个字节发送ACK */
            I2C_RDTrigger();                    /* I2C接收数据触发 */
        }
        else
        {
            I2C_ClearITPendingBit(I2C_Clr_TIDLE);  /* 清除发送空闲中断标志 */
            I2C_SendByte(g_txbuf[g_tx_count++]);   /* 发送数据 */
            I2C_ITConfig(I2C_IT_TIDLE, ENABLE);    /* 使能发送空闲中断 */
        }
    }

    if ((I2C_GetFlagStatus(I2C_Flag_SP) == SET) && (I2C_GetITStatus(I2C_IT_SP) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_SP);
        g_ending_flag = 1;

    }

    if ((I2C_GetFlagStatus(I2C_Flag_TIDLE) == SET) && (I2C_GetITStatus(I2C_IT_TIDLE) == SET))
    {
        I2C_ClearITPendingBit(I2C_Clr_TIDLE);

        if ((g_tx_count < g_tx_length) && (I2C_GetFlagStatus(I2C_Flag_NA) != SET))
        {
            I2C_SendByte(g_txbuf[g_tx_count++]);
        }
        else
        {
            I2C_SPTrigger();   /* I2C停止位触发 */
        }
    }

    if ((I2C_GetFlagStatus(I2C_Flag_RB) == SET) && (I2C_GetITStatus(I2C_IT_RB) == SET))
    {
        g_rxbuf[g_rx_count++] = I2C_RecByte();    /* 接收数据 */

        if (g_rx_count < g_rx_length)
        {
            if (g_rx_count == g_rx_length - 1)
            {
                I2C_RecModeConfig(I2C_RecMode_1);  /* 接收最后1字节后，发送NACK */
            }

            I2C_RDTrigger();   /* 接收数据触发 */
        }
        else
        {
            I2C_SPTrigger();   /* I2C停止位触发 */
        }
    }
}
