/*********************************************************

*文件名:  e2prom.h
*作  者:  AE Team
*版  本:  V1.01
*日  期:  2021/06/01
*描  述:  E2PROM模块程序头文件
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#ifndef __E2PROM_H__
#define __E2PROM_H__

#include "lib_config.h"
#include "uart.h"
#include "systick.h"

typedef enum
{
    page_size_8_byte  = 8,
    page_size_16_byte = 16
} page_size_type;

typedef enum
{
    rom_size_128_byte = 0,
    rom_size_256_byte = 1,
    rom_size_512_byte = 2,
    rom_size_1k_byte = 3,
    rom_size_2k_byte = 4
} rom_size_type;

void e2prom_init(void);
uint8_t e2prom_byte_write(uint16_t addr, uint8_t u8data, rom_size_type size);
uint8_t e2prom_page_write(uint16_t addr, uint8_t *u8data, page_size_type psize, rom_size_type size);
uint8_t e2prom_sequential_write(uint16_t addr, uint8_t *u8data, uint16_t write_cnt, rom_size_type size);
uint8_t e2prom_random_read(uint16_t addr, uint8_t *u8data, rom_size_type size);
uint8_t e2prom_sequential_read(uint16_t addr, uint8_t *u8data, uint8_t len, rom_size_type size);
uint8_t e2prom_reset(void);

#endif
