/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  FLASH IAP演示主程序
          FLASH的0xF000写数据0x12345678
          读取改地址数据是否写入，写入成功点灯LD1，失败点灯LD4
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    uint32_t g_rbuf = 0;
    uint32_t data = 0x12345678;
    uint32_t sta1 = 0;
    uint32_t sta2 = 0;
    uint32_t sta3 = 0;
    uint32_t sta4 = 0;

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    LightInit();

    GPIOB_SetBit(GPIO_Pin_15);   //熄灭LD4
    GPIOB_SetBit(GPIO_Pin_14);   //熄灭LD3
    GPIOA_SetBit(GPIO_Pin_12);   //熄灭LD2
    GPIOA_SetBit(GPIO_Pin_11);   //熄灭LD1

    IAP_FLASH_Unlock();

    sta1 = IAP_Code_PageErase(START_ADDR, ~START_ADDR);
    sta2 = IAPRead(&g_rbuf, START_ADDR, 1);
    sta3 = IAP_Code_WordProgram(START_ADDR, ~START_ADDR, data);
    sta4 = IAPRead(&g_rbuf, START_ADDR, 1);

    IAP_FLASH_Lock();

    while (1)
    {
        if (g_rbuf == 0x12345678 && sta1 == SUCCESS && sta2 == SUCCESS && sta3 == SUCCESS && sta4 == SUCCESS)
            GPIOA_ResetBit(GPIO_Pin_12);
        else
            GPIOB_ResetBit(GPIO_Pin_14);
    }
}

