/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_descriptor.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : Descriptor header file of EES
**********************************************************************************************************************/

#ifndef R_EES_DESCRIPTOR_H
#define R_EES_DESCRIPTOR_H

#include "r_ees_types.h"
#include "es_flash_common_api.h"

/* Defines */

/* Specifies the size of one physical data flash block */
#define R_EES_EXRFD_VALUE_U16_PHYSICAL_BLOCK_SIZE               (MCU_PAGE_SIZE)

/* Specifies the number of physical data flash blocks per one virtual block */
#define R_EES_EXRFD_VALUE_U08_PHYSICAL_BLOCKS_PER_VIRTUAL_BLOCK (4u)

/* Specifies the number of virtual blocks */
#define R_EES_EXRFD_VALUE_U08_POOL_VIRTUAL_BLOCKS               (4u)

/* Specifies the number of EES variables (1-254) */
#define R_EES_VALUE_U08_VAR_NO                                  (8u)


/* ----------------------------------------------------------------------------------------------------------------- */
/* ------------                                                                                         ------------ */
/* ------------      B E G I N    O F    U N T O U C H A B L E    D E C L A R A T I O N    A R E A      ------------ */
/* ------------                                                                                         ------------ */
/* ----------------------------------------------------------------------------------------------------------------- */

/* External references */
extern __far const uint8_t g_ar_u08_ees_descriptor[R_EES_VALUE_U08_VAR_NO + 2u];
extern __far const st_ees_exrfd_descriptor_t g_st_ees_exrfd_descriptor;
extern __near uint16_t g_ar_u16_ram_ref_table[R_EES_VALUE_U08_VAR_NO];

/* ----------------------------------------------------------------------------------------------------------------- */
/* ------------                                                                                         ------------ */
/* ------------        E N D    O F    U N T O U C H A B L E    D E C L A R A T I O N    A R E A        ------------ */
/* ------------                                                                                         ------------ */
/* ----------------------------------------------------------------------------------------------------------------- */

#endif /* end of R_EES_DESCRIPTOR_H */
