/**********************************************************************************************************************
    Program Name    : EEPROM Emulation Software (EES)
    
    File Name       : r_ees_api.h
    Program Version : V1.00
    Device(s)       : microcontroller
    Description     : API definition of EES
**********************************************************************************************************************/

#ifndef R_EES_API_H
#define R_EES_API_H

#include "r_ees.h"

/**********************************************************************************************************************
 Prototype declaration
 *********************************************************************************************************************/

extern R_EES_FAR_FUNC e_ees_ret_status_t R_EES_Init(uint8_t i_u08_cpu_frequency);
extern R_EES_FAR_FUNC e_ees_ret_status_t R_EES_Open(void);
extern R_EES_FAR_FUNC e_ees_ret_status_t R_EES_Close(void);
extern R_EES_FAR_FUNC void R_EES_Execute(st_ees_request_t __near * ionp_st_ees_request);
extern R_EES_FAR_FUNC void R_EES_Handler(void);
extern R_EES_FAR_FUNC e_ees_ret_status_t R_EES_GetSpace(uint16_t __near * onp_u16_space);

#endif /* end of R_EES_API_H */
