/*********************************************************
*Copyright (C), 2023, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2024/6/14
 * @描  述:  MCU自带Flash模拟EEPROM
 *           开辟ESS Pool。ESS Pool中包含4个ESS Block。每个ESS Block大小为2k字节。ESS Pool的起始地址为0x8000。
 *           测试步骤：
 *           1) 通过ESBurner使能芯片DATAFLASH空间：Page64~Page127；
 *           2) 用ES-LINK2的RX、TX连接开发板的PA22和PA23。
、*              PA22为MCU_UART_RX
、*              PA23为MCU_UART_TX
 *           3) main函数中会调用例子Sample_EES_Control。例子测试完成后，会打印信息。
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2024/6/14       AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include "main.h"

extern void Sample_EES_Control(void);

int fputc(int ch, FILE *f)
{
    while (!(UART_GetFlagStatus(UART3, UART_FLAG_TXIDLE))) {};

    UART_SendByte(UART3, (uint8_t)ch);
    UART_ClearITPendingBit(UART3, UART_Clr_TXIDLE);

    return ch;
}

/*********************************************************
函数名: void UARTInit(void)
描  述: 初始化UART
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UARTInit(void)
{
    GPIO_InitStruType y;
    UART_InitStruType uart;
    memset(&y, 0, sizeof(y));
    memset(&uart, 0, sizeof(uart));

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_6;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_8, &y);                 //PA8---TxD

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_6;
    y.GPIO_Direction = GPIO_Dir_In;
    y.GPIO_PUEN = GPIO_PUE_Input_Enable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_7, &y);                 //PA7---RxD

    uart.UART_StopBits = UART_StopBits_1;          //停止位：1
    uart.UART_TxMode = UART_DataMode_8;            //发送数据格式：8位数据
    uart.UART_TxPolar = UART_Polar_Normal;         //发送端口极性：正常
    uart.UART_RxMode = UART_DataMode_8;            //接收数据格式：8位数据
    uart.UART_RxPolar = UART_Polar_Normal;         //接收端口极性：正常
    uart.UART_BaudRate = 115200;                     //波特率
    uart.UART_ClockSet = UART_Clock_1;             //时钟选择：Pclk
    UART_Init(UART3, &uart);

    UART_TBIMConfig(UART3, UART_TRBIM_Byte);
    UART_RBIMConfig(UART3, UART_TRBIM_Byte);
    //UART_ITConfig(UART3, UART_IT_RB, ENABLE);
    //NVIC_Init(NVIC_UART3_IRQn, NVIC_Priority_1, ENABLE);
    UART3_TxEnable();                               //UART3发送使能
    UART3_RxEnable();
}

int main(void)
{
    SystemHRCSelect(SCU_HRC_48M);       //HRC选择48Hz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟
    
    __disable_irq();
    
    SCU_RegUnLock();
    SCU->FLASHWAIT.ACCT=1;              //FLASH等待时间1个周期
    SCU_RegLock();
    UARTInit();                         //UART初始化(115200,8,NO,1)
    
    __enable_irq();

    Sample_EES_Control();
    
    while (1);
}

/*************************END OF FILE**********************/
