/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  GPIO按键中断演示主程序
*         PA20每产生一次按键中断，PA12电平翻转一次
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"
#include "string.h"
/***************************************************************
 函数名：void KINTx_Init(void)
 描  述：按键中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void KINTx_Init(void)
{
    GPIO_InitStruType x;
    memset(&x, 0, sizeof(x));
    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Enable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_20, &x);

    KINT_Config(KINT4, KINT_SEL2, KINT_Trig_Rise);
    KINT4_MaskDisable();
    KINT4_Enable();
    NVIC_Init(NVIC_KINT_IRQn, NVIC_Priority_1, ENABLE);

    return;
}

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟
    DeviceClockAllEnable();             //打开所有外设时钟

    LightInit();                        //指示灯初始化
    KINTx_Init();

    while (1)
    {

    }
}
