/*********************************************************
*文件名:  adc.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/5
*描  述:  ADC模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "adc.h"
#include "string.h"
/*********************************************************
函数名: void ADC0_UserInit(void)
描  述: ADC初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void ADC0_UserInit(void)
{
    GPIO_InitStruType x;
    ADC_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    x.GPIO_Signal = GPIO_Pin_Signal_Analog;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOB, GPIO_Pin_6, &x);    //PB6

    y.ADC_ChS = ADC_CHS_AIN1;            //通道:AIN1
    y.ADC_ClkS = ADC_ClkS_PCLK;          //时钟：PCLK
    y.ADC_ClkDiv = ADC_ClkDiv_32;        //预分频：1:32  ADC转换时钟源一定要符合数据手册中ADC转化时钟源选择表
    y.ADC_BITSEL = ADC_BITSEL_12;        //分辨率：12位
    y.ADC_VrefP = ADC_VREFP_VDD;         //正向参考电压：VDD
    y.ADC_SampS = ADC_SMPS_HARD;         //AD采样模式选择：硬件
    y.ST = 7;
    y.ADC_VREFN = ADC_VREFN_SEL_VSS;
    ADC_Init(&y);                        //按照结构体的参数配置ADC

    ADC_ACP_Disable();

    ADC_IE_Enable();                     //使能中断

    NVIC_Init(NVIC_ADC_IRQn, NVIC_Priority_0, ENABLE);

    ADC_Enable();                        //使能ADC
}

/***************************************************************
 函数名：ADCACPConfig
 描  述：ADC ACP功能初始化
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void ADCACPConfig(void)
{
    ADC_ACP_TypeDef x;

    x.ACP_EN = ENABLE;
    x.ACPC_OVER_TIME = 0x3;             /* 自动转换比较的溢出时间 */
    x.ACPC_TIMES = ADC_ACPC_TIMES_8;    /* 自动转换比较次数选择位 */
    x.ACPC_MIN_TARGET = 1241;           /* 自动比较高阈值，当mean值小于该值时，会触发中断 */
    x.ACPC_MAX_TARGET = 2482;           /* 自动比较低阈值，当mean值大于该值时，会触发中断 */
    ADC_ACPConfig(&x);
}

/*********************************************************
函数名: uint16_t ADCRead(void)
描  述: 读取ADC采样值，带滤波
输入值: 无
输出值: 无
返回值: 采样值
**********************************************************/
uint16_t ADCRead(void)
{
    uint8_t i;
    uint32_t max, min, sum, ad_temp;

    max = 0x00;
    min = 0x0fff;
    sum = 0x00;

    for (i = 0; i < 18; i++)
    {
        ADC_Start();

        while (ADC_GetConvStatus() == SET);

        ADC_ClearIFStatus(ADC_IF);

        ad_temp = ADC_GetConvValue();

        if (ad_temp > max)
        {
            max = ad_temp;
        }

        if (ad_temp < min)
        {
            min = ad_temp;
        }

        sum += ad_temp;
    }

    sum -= min;
    sum -= max;
    return sum >> 4;
}
