        .syntax unified
        .cpu cortex-m0
        .arch armv6-m
        .fpu softvfp
        .thumb
 
/*  Stack Configuration
    Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
*/
       
        .equ Stack_Size,  0x00000400
 
        .section  .stack, "wa"
        .align 3
        .global Stack_Mem
        .global Stack_Size
Stack_Mem:     
        .if Stack_Size
        .space   Stack_Size
        .endif
        .size    Stack_Mem,.-Stack_Mem
        .set     Stack_Size,.-Stack_Mem
__initial_sp:
 
 
/*
 <h> Heap Configuration
   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
</h>
*/
 
        .equ     Heap_Size,       0x00000010
 
        .section  .heap, "wa"
        .align 3
 
        .global Heap_Mem_Start
        .global Heap_Mem_End
Heap_Mem_Start:     
        .if Heap_Size
        .space   Heap_Size
        .endif        
Heap_Mem_End:     
 
 
/* Vector Table Mapped to Address 0 at Reset*/
                                        
        .section  .vectors ,"wax"
        .global  __vector
        .type  __vector, %object
        
__vector: 
                .long     __initial_sp  /* Top of Stack*/
                .long     Reset_IRQHandler  /*Reset_IRQHandler*/    
                .long     NMI_IRQHandler  /* NMI IRQIRQHandler*/
                .long     HardFault_IRQHandler         /* Hard Fault IRQIRQHandler*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     SVC_IRQHandler               /* SVCall IRQIRQHandler*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     PendSV_IRQHandler            /* PendSV IRQIRQHandler*/
                .long     SysTick_IRQHandler           /* SysTick IRQIRQHandler*/
 
                /* External Interrupts*/
                .long     PINT0_IRQHandler				/*16, pint0 IRQIRQHandler*/
                .long     PINT1_IRQHandler				/*17, pint1 IRQIRQHandler*/
                .long     PINT2_IRQHandler				/*18, pint2 IRQIRQHandler*/
                .long     PINT3_IRQHandler				/*19, pint3 IRQIRQHandler*/
                .long     PINT4_IRQHandler				/*20, pint4 IRQIRQHandler*/
                .long     PINT5_IRQHandler 				/*21, pint5 IRQIRQHandler*/
                .long     PINT6_IRQHandler 				/*22, pint6 IRQIRQHandler*/
                .long     PINT7_IRQHandler 				/*23, pint7 IRQIRQHandler*/
                .long     T16N0_IRQHandler 				/*24, t16n0 IRQIRQHandler*/
                .long     T16N1_IRQHandler 				/*25, t16n1 IRQIRQHandler*/
                .long     T16N2_IRQHandler 				/*26, t16n2 IRQIRQHandler*/
				.long     T16N3_IRQHandler 				/*27, t16n3 IRQIRQHandler*/
                .long     T32N0_IRQHandler 				/*28, t32n0 IRQIRQHandler*/
                .long     0  								 /*29, Reserved     */
                .long     0                                  /*30, Reserved              */
                .long     WWDT_IRQHandler           /*31, WWDT IRQHandler*/
                .long     IWDT_IRQHandler           /*32, IWDT IRQHandler*/
                .long     0                         /*33, Reserved*/
                .long     KINT_IRQHandler           /*34, KINT IRQHandler*/
                .long     ADC_IRQHandler            /*35, ADC IRQHandler*/
                .long     0                         /*36, Reserved*/
                .long     LVD_IRQHandler            /*37, LVD IRQHandler*/
                .long     0                         /*38, Reserved*/
                .long     UART0_IRQHandler          /*39, UART0 IRQHandler*/
                .long     UART1_IRQHandler          /*40, UART1 IRQHandler*/
                .long     UART2_IRQHandler          /*41, UART2 IRQHandler*/
                .long     0                         /*42, Reserved*/
                .long     0                         /*43, Reserved*/
                .long     SPI1_IRQHandler           /*44, SPI1 IRQHandler*/
                .long     I2C0_IRQHandler           /*45, I2C0 IRQHandler*/
                .long     0                         /*46, Reserved*/
                .long     CCM_IRQHandler            /*47, CCM IRQHandler*/
 
 
               .size  __vector, .-__vector
                
.thumb
                .text
                .thumb_func
                .global  Reset_IRQHandler
                .type Reset_IRQHandler,%function
Reset_IRQHandler:
           
            .extern main
                .extern __start
                .extern InitRam
.extern SystemInit
                LDR     R0, =SystemInit
                BLX     R0 
                LDR     R0, =InitRam
                BLX     R0
                LDR     R0, =main
                BLX      R0
             
               .size  Reset_IRQHandler, .-Reset_IRQHandler
 
                .text
/* Dummy Exception IRQHandlers (infinite loops which can be modified)*/                
               
                 .weak NMI_IRQHandler
                 .type NMI_IRQHandler,%function
NMI_IRQHandler:     
                 B       .
                 .size  NMI_IRQHandler, .-NMI_IRQHandler
                
                 .weak  HardFault_IRQHandler
                 .type  HardFault_IRQHandler,%function
HardFault_IRQHandler:
                B .
                .size  HardFault_IRQHandler, .-HardFault_IRQHandler
                
                .weak SVC_IRQHandler
                .type SVC_IRQHandler,%function
SVC_IRQHandler: 
                B       .
                .size  SVC_IRQHandler, .-SVC_IRQHandler
              
                
                .weak  PendSV_IRQHandler
                .type  PendSV_IRQHandler,%function
PendSV_IRQHandler:
                B .
          .size  PendSV_IRQHandler, .-PendSV_IRQHandler
                 
                .weak  SysTick_IRQHandler
                .type  SysTick_IRQHandler,%function
SysTick_IRQHandler: 
                B .
                .size  SysTick_IRQHandler, .-SysTick_IRQHandler
 
                .global Default_IRQHandler
                .type  Default_IRQHandler,%function
Default_IRQHandler: 
                B       .
                .size  Default_IRQHandler, .-Default_IRQHandler
                .macro IRQ handler
                .weak \handler
                .set \handler,Default_IRQHandler 
                .endm
                
IRQ PINT0_IRQHandler
IRQ PINT1_IRQHandler
IRQ PINT2_IRQHandler
IRQ PINT3_IRQHandler
IRQ PINT4_IRQHandler
IRQ PINT5_IRQHandler
IRQ PINT6_IRQHandler
IRQ PINT7_IRQHandler
IRQ T16N0_IRQHandler
IRQ T16N1_IRQHandler
IRQ T16N2_IRQHandler
IRQ T16N3_IRQHandler
IRQ T32N0_IRQHandler
IRQ WWDT_IRQHandler
IRQ IWDT_IRQHandler
IRQ RTC_IRQHandler
IRQ KINT_IRQHandler
IRQ ADC_IRQHandler
IRQ LVD_IRQHandler
IRQ UART0_IRQHandler
IRQ UART1_IRQHandler
IRQ UART2_IRQHandler
IRQ SPI1_IRQHandler
IRQ I2C0_IRQHandler
IRQ CCM_IRQHandler
 
 

.end
