/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  systick.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
#include "ES8P5066.h"
#include "macro.h"
#include "typedef.h"

uint32_t  g_boot_timer;     /* 超时引导程序计时器 */
uint32_t  g_frame_timer;    /* 帧间隔超时计时器 */
uint8_t   g_boot;           /* 引导程序标识 */

extern isp_data_t g_isp_data;

void uart0_reset(void);
void uart1_reset(void);
void uart2_reset(void);
void uart_init(UART_TypeDef *uartx);

/***************************************************************
函数名：SysTick_Handler
描  述: SysTick中断服务程序
输入值：无
输出值：无
返回值：无
***************************************************************/
void SysTick_IRQHandler(void)
{
    if (GPIO->PBPORT.PORT_0 == 0)       /* BootPIN拉低 */
    {
        if (g_boot_timer != 0)
        {
            g_boot_timer--;

            if (g_boot_timer == 0)
            {
                g_boot = 1;             /* 引导程序 */
            }
        }
    }

    if (g_frame_timer != 0)             /* 帧字节间隔时间超时则复位UART，并使命令重新进入等待命令码的状态 */
    {
        g_frame_timer--;

        if (g_frame_timer == 0)
        {
            g_isp_data.step = WAIT_REV_INS;
            uart0_reset();
            uart_init(UART0);
        }
    }
}

/*************************END OF FILE**********************/
