/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  go.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
 
#include "ES8P5066.h"
#include "macro.h"
#include "typedef.h"
#include "lib_flashiap.h"

#define APP_ADDRESS BOOT_TO_ADDR

typedef  void (*FunVoidType)(void);


static uint32_t ApplicationAddress;
static uint32_t m_JumpAddress;
static FunVoidType JumpToApplication;

/***************************************************************
函数名：sfr_reset
描  述: 引导程序前对BootROM里使用的寄存器恢复复位值
输入值：无
输出值：无
返回值：无
***************************************************************/
void sfr_reset(void)
{

    SysTick->CTRL = 0x00;
    SysTick->LOAD = 0;

    UART0->CON0.RRST = 1;
    UART0->CON0.TRST = 1;
    UART0->CON0.Word = 0;
    UART0->CON1.Word = 0;
    UART0->IE.Word = 0;
    UART0->IF.Word = 0;
    UART0->BRR.Word = 0;

    GPIO->PADATA.Word = 0;
    GPIO->PADIR.Word = 0xFFFFFFFF;
    GPIO->PAINEB.Word = 0;
    GPIO->PAFUNC2.Word = 0;
    GPIO->PAFUNC3.Word = 0;
    GPIO->PAPDE.Word = 0;

    WWDT->LOCK.Word = 0;

    SCU->PROT.Word = 0;
}

/***************************************************************
函数名：JumpToApp
描  述: 引导程序到指定位置
输入值：目标地址，必须256byte对齐
输出值：无
返回值：无
***************************************************************/
void JumpToApp(uint32_t addr)
{
    __disable_irq(); /* 关中断 */
    NVIC->ICER[0] = 0xFFFFFFFF;  /* 关闭所有IRQ */

    SCU->PROT.Word = 0x55AA6996;  /* 解除SCU写保护 */
    ApplicationAddress = addr & 0xFFFFFF00; /* 保证地址256对齐 */
    REMAP_EN;
    SCU->TBLOFF.TBLOFF = ApplicationAddress; /* 中断向量重映射 */

    sfr_reset();        /* 恢复寄存器 */
    __enable_irq();     /* 使能中断 */

    m_JumpAddress = *(volatile uint32_t *)(ApplicationAddress + 4);  /* 获取复位向量 */
    JumpToApplication = (FunVoidType) m_JumpAddress;

    __set_MSP(*(volatile uint32_t *) ApplicationAddress);  /* 初始化栈顶 */
    JumpToApplication();  /* 程序跳转到复位向量指向的位置 */
}

/*************************END OF FILE**********************/
