/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  wdt.h
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  WDT初始化程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "wdt.h"
#include "string.h"

/***************************************************************
 描  述：WDT初始化初始化
 输入值：无
 返回值：无
***************************************************************/
void WDTInit(void)
{
    WWDT_InitStruType x;
	memset(&x, 0, sizeof(x));
	
    x.WDT_Tms = 2000;
    x.WDT_IE = Enable;              /* WWDT中断使能 */
    x.WDT_Rst = Enable;             /* WWDT复位使能 */
    x.WDT_Clock = WWDT_CLOCK_WDT;   /* LRC */
    x.WDT_Win = WDT_WIN_75;         /* 75%窗口内禁止，窗口内喂狗将复位 */
    WWDT_Init(&x);

    /* 使能WWDT */
    WWDT_Enable();

    NVIC_Init(NVIC_WWDT_IRQn, NVIC_Priority_2, Enable);
}


/*************************END OF FILE**********************/
