/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  IWDT演示主程序
 *        系统复位将产生LED1亮5S
 *        当MCU上电后，LED1先亮5S，然后进入循环先灭0.5秒，再亮0.5S
 *        本例程通过判断端口电平状态来决定是否喂狗，当PA3端口电平为低电平时，不喂狗，引起系统复位
 *        端口引脚连接: PA3
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"


int main()
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();

    User_SysTickInit();
    LightInit(LED1_PIN);
    LightOff(LED1_PIN);

    GPIO_Pins_Init();

    LightOn(LED1_PIN);
    Delay_100us(50000);

    WDTInit();

    while (1)
    {
        LightOff(LED1_PIN);
        Delay_100us(5000);

        if (0x1 == GPIO_ReadBit(GPIO_Pin_A3))
        {
            if (0x01 == IWDT_GetFlagStatus())
                IWDT_Clear();
        }

        LightOn(LED1_PIN);
        Delay_100us(5000);
    }
}


/*************************END OF FILE**********************/
