/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  UART模块例程
 *          使用XCOM进行交互
 *          上电后MCU依次循环发送“hello word”，“welcome to essemi“以及循环次数
 *			使用UART_printf函数前需要以下两个步骤：
 *			1、keil勾选Use MicroLIB 2、IAR/keil #define __PRINTF_USE_UART0__
 *          RXD - PA22
 *          TXD - PA23
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

int main()
{
    uint8_t i = 0x0U;
    uint8_t buf[] = {"Welcome to essemi !"};

    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();

    User_SysTickInit();
    UARTInit();

    while (1)
    {
        Delay_10us(100000);
        printf("Hello world! \r\n");
        Delay_10us(100000);
        printf("%s \r\n", buf);
        Delay_10us(100000);
        printf("cycle = %d \r\n", i);
        i++;
    }
}


/*************************END OF FILE**********************/
