/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"
#include "lib_config.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    /* 用于10us定时器 */
    TimingDelay_Decrement();

    /* 用于计时发送数据的字节间隔 */
    if (g_tx_start_flag)
    {
        if (g_tx_time >= 20)
        {
            g_tx_finish_flag = 0;
            g_tx_start_flag = 0;
        }
        else
        {
            g_tx_time++;
        }
    }
    else
    {
        g_tx_time = 0x0U;
    }

    /* 用于计时接收数据的字节间隔 */
    if (g_rx_start_flag)
    {
        if (g_rx_time >= 20)
        {
            g_rx_finish_flag = 0;
            g_rx_start_flag = 0;
        }
        else
        {
            g_rx_time++;
        }
    }
    else
    {
        g_rx_time = 0x0U;
    }
}

/*********************************************************
函数名: void UART0_IRQHandler(void)
描  述: UART中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UART0_IRQHandler(void)
{
    if ((UART_GetITStatus(UART0, UART_IT_TC) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_TC) != RESET))
    {
        UART_ClearITPendingBit(UART0, UART_FLAG_TC);

        if ((g_tx_count >= g_tx_length) || (g_tx_time >= 20) || (g_tx_finish_flag >= 20))
        {
            g_tx_finish_flag = 0;
        }
        else
        {
            UART_SendByte(UART0, g_txbuf[g_tx_count++]);

            g_tx_start_flag = 0x1U;
            g_tx_time = 0x0U;
        }
    }

    if ((UART_GetITStatus(UART0, UART_IT_RB) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_RB) != RESET))
    {
        g_rxbuf[g_rx_count] = UART_RecByte(UART0);
        g_rx_count++;

        g_rx_start_flag = 0x01U;
        g_rx_time = 0x0U;
    }
}


/*************************END OF FILE**********************/
