/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名: main.c
 * @作  者: AE Team
 * @版  本: V1.01
 * @日  期: 2022/07/25
 * @描  述: UART演示主程序
 *          定义了串口通信主机请求/从机应答的通讯协议
 *          通讯协议如下：
 *          同一帧相邻字节时间间隔不能超过200us
 *          数据帧头1（固定）    0x55
 *          数据帧头2（固定）    0xAA
 *          设备地址（Addr）     0x01
 *          数据字节（N个）      DataN
 *          校验码（异或和）     = 0x55 ^ 0xAA ^ Addr ^ Data1 ^ … ^ DataN
 *          数据帧尾1（固定）    0x5A
 *          数据帧尾2（固定）    0xA5
 *          本例程按照协议包装及校验数据帧，MCU接收上位机发送的数据帧，应答相同的数据帧
 *          例如：
 *          上位机发送:        55 AA 01 45 41 53 54 53 4F 46 54 F3 5A A5
 *          MCU回复:      55 AA 01 45 41 53 54 53 4F 46 54 F3 5A A5
 *          修改上述数据帧(55 AA 01 45 41 53 54 53 4F 46 54 F3 5A A5)中的任意字节则将因校验错误而导致MCU丢弃该数据帧
 *          RXD - PA22
 *          TXD - PA23
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

int main()
{
    uint8_t txbuf[100];     /* 发送数据缓存 */
    uint8_t tx_length;      /* 发送数据长度 */
    uint8_t rxbuf[100];     /* 接收数据缓存 */
    uint8_t rx_length;      /* 接收数据长度 */

    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();

    User_SysTickInit();
    SysTick_Enable();
    UARTInit();

    memcpy(txbuf, "Start: ", 7);

    tx_length = 7;
    UARTTxData(txbuf, tx_length);                   /* 发送数据帧“Start:” */

    while (1)
    {
        rx_length = UARTRxData(rxbuf);

        if (rx_length)
        {
            memcpy(txbuf, rxbuf, rx_length);
            tx_length = rx_length;
            UARTTxData(txbuf, tx_length);
        }
    }
}


/*************************END OF FILE**********************/
