/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"
#include "lib_config.h"
#include "uart.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}


/*********************************************************
函数名: void UART0_IRQHandler(void)
描  述: UART中断服务程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UART0_IRQHandler(void)
{
    if ((UART_GetITStatus(UART0, UART_IT_RB) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_RB) != RESET))
    {
        if (synch && (0x0 == UART_AutoBaudResult(UART0)))
        {
            g_buffer = UART_RecByte(UART0);
        }
        else
        {
            uint8_t  i;
            uint8_t  data2send[30] = {"auto baud detect success \r"};

            synch = 0x01U;
            UART_RecByte(UART0);

            for (i = 0; i < 27; i++)
            {
                while (UART_GetFlagStatus(UART0, UART_FLAG_TB) == RESET);

                UART_SendByte(UART0, data2send[i]);
            }
        }

        UART_ITConfig(UART0, UART_IT_TB, Enable);               /* UART0发送中断使能 */
    }

    if ((UART_GetITStatus(UART0, UART_IT_TB) != RESET) && (UART_GetFlagStatus(UART0, UART_FLAG_TB) != RESET))
    {
        UART_SendByte(UART0, g_buffer);
        UART_ITConfig(UART0, UART_IT_TB, Disable);          /* UART0发送中断禁止 */
    }
}


/*************************END OF FILE**********************/
