/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块初始化程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"

/*********************************************************
函数名: void T32NxInit(void)
描  述: T32Nx初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32NxInit(void)
{
    T32Nx_BaseInitStruType x;
	memset(&x, 0, sizeof(x));

    x.T32Nx_ClkS   = T32Nx_ClkS_PCLK;
    x.T32Nx_Mode   = T32Nx_Mode_TC0;
    x.T32Nx_SYNC   = Disable;
    x.T32Nx_EDGE   = T32Nx_EDGE_Rise;
    x.T32Nx_PREMAT = 0x100;
    T32Nx_BaseInit(T32N0, &x);

    T32Nx_MAT0ITConfig(T32N0, T32Nx_Clr_Int);
    T32Nx_SetMAT0(T32N0, SystemCoreClock / 256); /* 定时1s */

    T32Nx_ITConfig(T32N0, T32Nx_IT_MAT0, Enable);
    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, Enable);

    T32Nx_Enable(T32N0);

    return;
}


/*************************END OF FILE**********************/
