/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @ļ:  irqhandler.c
 * @  :  AE Team
 * @  :  V1.01
 * @  :  2022/07/25
 * @  :  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}

extern uint32_t count00;
extern uint32_t buf00[50];
extern uint32_t count01;
extern uint32_t buf01[50];

/*********************************************************
: void T32N0_IRQHandler(void)
  : T32N0ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N0_IRQHandler(void)
{
    if ((T32Nx_GetFlagStatus(T32N0, T32Nx_IT_CAP0) == SET) && (T32Nx_GetITStatus(T32N0, T32Nx_IT_CAP0) == SET))
    {
        T32Nx_ClearITPendingBit(T32N0, T32Nx_IT_CAP0);

        LightOn(LED1_PIN);

        buf00[count00++]  = T32N0->MAT0.Word;
        buf00[count00++]  = T32N0->MAT2.Word;

        if (count00 >= 50)
        {
            count00 = 0;
        }
    }

    if ((T32Nx_GetFlagStatus(T32N0, T32Nx_IT_CAP1) == SET) && (T32Nx_GetITStatus(T32N0, T32Nx_IT_CAP1) == SET))
    {
        T32Nx_ClearITPendingBit(T32N0, T32Nx_IT_CAP1);

        LightOff(LED1_PIN);

        buf01[count01++]  = T32N0->MAT1.Word;
        buf01[count01++]  = T32N0->MAT3.Word;

        if (count01 >= 50)
        {
            count01 = 0;
        }

    }

    return;
}


/*************************END OF FILE**********************/
