/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块初始化程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"


/*********************************************************
函数名: void T32N_Pin_Init(void)
描  述: T32N输入捕捉端口初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32N_Pin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func2;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Disable;

    GPIO_Init(GPIO_Pin_A2, &x);
    GPIO_Init(GPIO_Pin_A3, &x);
}

/*********************************************************
函数名: void T32N0Init(void)
描  述: T32N0初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T32NxInit(void)
{
    T32Nx_BaseInitStruType x;
    T32Nx_CapInitStruType  y;
	memset(&x, 0, sizeof(x));
	memset(&y, 0, sizeof(y));

    /* 内部时钟，预分频为1:1 */
    x.T32Nx_ClkS   = T32Nx_ClkS_PCLK;
    x.T32Nx_Mode   = T32Nx_Mode_CAP;
    x.T32Nx_PREMAT = 0x01;
    x.T32Nx_SYNC = Disable;             /* 不同步外部时钟 */
    x.T32Nx_EDGE = T32Nx_EDGE_Rise;     /* 外部时钟计数边沿选择:上升沿 */
    T32Nx_BaseInit(T32N0, &x);

    /* 捕捉0/1重载计数器使能，捕捉三次后重载，捕捉输入端口0/1使能，上升沿捕捉 */
    y.T32Nx_CAPCAPL0 = Enable;
    y.T32Nx_CAPCAPL1 = Enable;
    y.T32Nx_CapFall = Disable;
    y.T32Nx_CapRise = Enable;
    y.T32Nx_CapIS0 = Enable;
    y.T32Nx_CapIS1 = Enable;
    y.T32Nx_CapTime = T32Nx_CapTime_3;
    T32Nx_CapInit(T32N0, &y);

    /* MAT0/MAT1/MAT2/MAT3继续计数，不产生中断 */
    T32Nx_MAT0ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT1ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT2ITConfig(T32N0, T32Nx_Go_No);
    T32Nx_MAT3ITConfig(T32N0, T32Nx_Go_No);

    /* 配置CON0以及MAT0、MAT1、MAT2、MAT3 */
    T32Nx_SetCNT(T32N0, 0);  


    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, Enable);

    T32N_Pin_Init();

    T32Nx_Enable(T32N0);
    /* 中断使能 */
    T32Nx_ITConfig(T32N0, T32Nx_IT_CAP0, Enable);
    T32Nx_ITConfig(T32N0, T32Nx_IT_CAP1, Enable);
    return;
}


/*************************END OF FILE**********************/
