/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块初始化程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"

/*********************************************************
函数名: void T16N_Pin_Init(void)
描  述: T16N外部输入端口初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N_Pin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func2;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Disable;

    GPIO_Init(GPIO_Pin_A5, &x);
}

/*********************************************************
函数名: void T16NxInit(void)
描  述: T16Nx初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16NxInit(T16N_TypeDef *T16_timer)
{
    T16Nx_BaseInitStruType x;
	memset(&x, 0, sizeof(x));

    x.T16Nx_ClkS   = T16Nx_ClkS_CK0;
    x.T16Nx_Mode   = T16Nx_Mode_TC0;
    x.T16Nx_SYNC   = Disable;
    x.T16Nx_EDGE   = T16Nx_EDGE_Rise;
    x.T16Nx_PREMAT = 0x01;          /* 预分频比1:1 */
    T16Nx_BaseInit(T16_timer, &x);
    T16Nx_MAT0ITConfig(T16_timer, T16Nx_Clr_Int);
    T16Nx_SetMAT0(T16_timer, 1);
    T16Nx_ITConfig(T16_timer, T16Nx_IT_MAT0, Enable);

    if (T16_timer == T16N0)
    {
        NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N1)
    {
        NVIC_Init(NVIC_T16N1_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N2)
    {
        NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N3)
    {
        NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, Enable);
    }

    T16N_Pin_Init();
    T16Nx_Enable(T16_timer);

    return;
}


/*************************END OF FILE**********************/
