/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.h
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块初始化配置程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"


/*********************************************************
函数名: void T16N_Pin_Init(void)
描  述: T16N输入捕捉端口初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N_Pin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func2;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Disable;

    GPIO_Init(GPIO_Pin_A4, &x);
    GPIO_Init(GPIO_Pin_A5, &x);
}

/*********************************************************
函数名: void T16N0Init(void)
描  述: T16N0初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16NxInit(T16N_TypeDef *T16_timer)
{
    T16Nx_BaseInitStruType x;
    T16Nx_CapInitStruType  y;
	memset(&x, 0, sizeof(x));
	memset(&y, 0, sizeof(y));

    /* 内部时钟，预分频为1:1 */
    x.T16Nx_ClkS   = T16Nx_ClkS_PCLK;
    x.T16Nx_Mode   = T16Nx_Mode_CAP;
    x.T16Nx_PREMAT = 0x01;
    x.T16Nx_SYNC = Disable;             /* 不同步外部时钟 */
    x.T16Nx_EDGE = T16Nx_EDGE_Rise;     /* 外部时钟计数边沿选择:上升沿 */
    T16Nx_BaseInit(T16_timer, &x);

    /* 捕捉0/1重载计数器使能，捕捉三次后重载，捕捉输入端口0/1使能，上升沿捕捉 */
    y.T16Nx_CAPCAPL0 = Enable;
    y.T16Nx_CAPCAPL1 = Enable;
    y.T16Nx_CapFall = Disable;
    y.T16Nx_CapRise = Enable;
    y.T16Nx_CapIS0 = Enable;
    y.T16Nx_CapIS1 = Enable;
    y.T16Nx_CapTime = T16Nx_CapTime_3;
    T16Nx_CapInit(T16_timer, &y);

    /* MAT0/MAT1/MAT2/MAT3继续计数，不产生中断 */
    T16Nx_MAT0ITConfig(T16_timer, T16Nx_Go_No);
    T16Nx_MAT1ITConfig(T16_timer, T16Nx_Go_No);
    T16Nx_MAT2ITConfig(T16_timer, T16Nx_Go_No);
    T16Nx_MAT3ITConfig(T16_timer, T16Nx_Go_No);

    /* 配置CON0以及MAT0、MAT1、MAT2、MAT3 */
    T16Nx_SetCNT0(T16_timer, 0);

    if (T16_timer == T16N0)
    {
        NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N1)
    {
        NVIC_Init(NVIC_T16N1_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N2)
    {
        NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, Enable);
    }
    else if (T16_timer == T16N3)
    {
        NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, Enable);
    }

    T16N_Pin_Init();

    T16Nx_Enable(T16_timer);
    /* 中断使能 */
    T16Nx_ITConfig(T16_timer, T16Nx_IT_CAP0, Enable);
    T16Nx_ITConfig(T16_timer, T16Nx_IT_CAP1, Enable);
    return;
}


/*************************END OF FILE**********************/
