/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  16位引脚捕捉器示例程序
			PA4，PA5引脚分别复用做T16N0IN0以及T16N0IN1，用于捕捉输入的上升沿方波信号
			当PA4捕捉到上升沿时熄灭LED1，当PA5捕捉到上升沿信号时点亮LED1，输入不同频率的PWM可看到LED1不同的闪烁效果
			buf00及buf01分别保存T16N0IN0以及T16N0IN1捕捉事件发生时，MAT0和MAT2以及MAT1和MAT3的值
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

uint32_t count00 = 0;
uint32_t buf00[50];
uint32_t count01 = 0;
uint32_t buf01[50];

int main(void)
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();

    T16NxInit(T16N0);
    LightInit(LED1_PIN);
    LightOff(LED1_PIN);

    while (1)
    {
    }

}


/*************************END OF FILE**********************/
