/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}

/*********************************************************
函数名: void SPI1_IRQHandler(void)
描  述: SPI中断处理程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void SPI1_IRQHandler(void)
{
    if ((SPI_GetFlagStatus(SPI1, SPI_Flag_RB) == SET) && (SPI_GetITStatus(SPI1, SPI_IT_RB) == SET))
    {
        g_rbuf[recv_cnt++] = SPI_RecByte(SPI1);
        memcpy(g_wbuf, g_rbuf, recv_cnt);

        if (recv_cnt > 7)
        {
            recv_cnt = 0;
        }
    }

    if ((SPI_GetFlagStatus(SPI1, SPI_Flag_TB) == SET) && (SPI_GetITStatus(SPI1, SPI_IT_TB) == SET))
    {
        SPI_SendByte(SPI1, g_wbuf[send_cnt++]);

        if (send_cnt > 7)
        {
            send_cnt = 0;
        }
    }
}


/*************************END OF FILE**********************/
